/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.aireducer.util;

import com.charles445.aireducer.AIReducer;
import com.charles445.aireducer.util.ReflectUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WorldRadiusUtil {
    public static WorldRadiusUtil instance = new WorldRadiusUtil();
    private Method m_isChunkLoaded;
    private boolean errorgetEntitiesInAABBexcluding = false;
    private boolean errorgetEntitiesInAABB = false;
    private boolean working = false;

    public WorldRadiusUtil() {
        try {
            this.m_isChunkLoaded = ReflectUtil.findMethodAny(World.class, "func_175680_a", "isChunkLoaded", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            this.working = true;
            AIReducer.logger.debug("WorldRadiusUtil initialized");
        }
        catch (Exception e) {
            AIReducer.logger.error("WorldRadiusUtil failed, please consider sending this log to the AIReducer dev!", (Throwable)e);
        }
    }

    public List<Entity> getEntitiesWithinAABBExcludingEntity(World world, @Nullable Entity entityIn, AxisAlignedBB bb, double size) {
        if (!this.working) {
            return world.func_72839_b(entityIn, bb);
        }
        return this.getEntitiesInAABBexcluding(world, entityIn, bb, (Predicate<? super Entity>)EntitySelectors.field_180132_d, size);
    }

    public List<Entity> getEntitiesInAABBexcluding(World world, @Nullable Entity entity, AxisAlignedBB bb, @Nullable Predicate<? super Entity> predicate, double size) {
        if (!this.working) {
            return world.func_175674_a(entity, bb, predicate);
        }
        ArrayList list = Lists.newArrayList();
        int j2 = MathHelper.func_76128_c((double)((bb.field_72340_a - size) / 16.0));
        int k2 = MathHelper.func_76128_c((double)((bb.field_72336_d + size) / 16.0));
        int l2 = MathHelper.func_76128_c((double)((bb.field_72339_c - size) / 16.0));
        int i3 = MathHelper.func_76128_c((double)((bb.field_72334_f + size) / 16.0));
        for (int j3 = j2; j3 <= k2; ++j3) {
            for (int k3 = l2; k3 <= i3; ++k3) {
                try {
                    if (!((Boolean)this.m_isChunkLoaded.invoke((Object)world, j3, k3, true)).booleanValue()) continue;
                    Chunk chunk = world.func_72964_e(j3, k3);
                    this.getEntitiesWithinAABBForEntity(chunk, entity, bb, list, predicate, size);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    if (!this.errorgetEntitiesInAABBexcluding) {
                        this.errorgetEntitiesInAABBexcluding = true;
                        e.printStackTrace();
                    }
                    return world.func_175674_a(entity, bb, predicate);
                }
            }
        }
        return list;
    }

    public <T extends Entity> List<T> getEntitiesWithinAABB(World world, Class<? extends T> classEntity, AxisAlignedBB bb, double size) {
        if (!this.working) {
            return world.func_72872_a(classEntity, bb);
        }
        return this.getEntitiesWithinAABB(world, classEntity, bb, EntitySelectors.field_180132_d, size);
    }

    public <T extends Entity> List<T> getEntitiesWithinAABB(World world, Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter, double size) {
        if (!this.working) {
            return world.func_175647_a(clazz, aabb, filter);
        }
        int j2 = MathHelper.func_76128_c((double)((aabb.field_72340_a - size) / 16.0));
        int k2 = MathHelper.func_76143_f((double)((aabb.field_72336_d + size) / 16.0));
        int l2 = MathHelper.func_76128_c((double)((aabb.field_72339_c - size) / 16.0));
        int i3 = MathHelper.func_76143_f((double)((aabb.field_72334_f + size) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                try {
                    if (!((Boolean)this.m_isChunkLoaded.invoke((Object)world, j3, k3, true)).booleanValue()) continue;
                    Chunk chunk = world.func_72964_e(j3, k3);
                    this.getEntitiesOfTypeWithinAABB(chunk, clazz, aabb, list, filter, size);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    if (!this.errorgetEntitiesInAABB) {
                        this.errorgetEntitiesInAABB = true;
                        e.printStackTrace();
                    }
                    return world.func_175647_a(clazz, aabb, filter);
                }
            }
        }
        return list;
    }

    public <T extends Entity> T findNearestEntityWithinAABB(World world, Class<? extends T> entityType, AxisAlignedBB aabb, T closestTo, double size) {
        if (!this.working) {
            return (T)world.func_72857_a(entityType, aabb, closestTo);
        }
        List<T> list = this.getEntitiesWithinAABB(world, entityType, aabb, size);
        Entity t = null;
        double d0 = Double.MAX_VALUE;
        for (int j2 = 0; j2 < list.size(); ++j2) {
            double d1;
            Entity t1 = (Entity)list.get(j2);
            if (t1 == closestTo || !EntitySelectors.field_180132_d.apply((Object)t1) || !((d1 = closestTo.func_70068_e(t1)) <= d0)) continue;
            t = t1;
            d0 = d1;
        }
        return (T)t;
    }

    public <T extends Entity> void getEntitiesOfTypeWithinAABB(Chunk chunk, Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, Predicate<? super T> filter, double size) {
        if (!this.working) {
            chunk.func_177430_a(entityClass, aabb, listToFill, filter);
            return;
        }
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        int i = MathHelper.func_76128_c((double)((aabb.field_72338_b - size) / 16.0));
        int j = MathHelper.func_76128_c((double)((aabb.field_72337_e + size) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(entityLists.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(entityLists.length - 1));
        for (int k = i; k <= j; ++k) {
            for (Entity t : entityLists[k].func_180215_b(entityClass)) {
                if (!t.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.apply((Object)t)) continue;
                listToFill.add(t);
            }
        }
    }

    public void getEntitiesWithinAABBForEntity(Chunk chunk, @Nullable Entity entityIn, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> filter, double size) {
        if (!this.working) {
            chunk.func_177414_a(entityIn, aabb, listToFill, filter);
        }
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        int i = MathHelper.func_76128_c((double)((aabb.field_72338_b - size) / 16.0));
        int j = MathHelper.func_76128_c((double)((aabb.field_72337_e + size) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(entityLists.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(entityLists.length - 1));
        for (int k = i; k <= j; ++k) {
            if (entityLists[k].isEmpty()) continue;
            for (Entity entity : entityLists[k]) {
                Entity[] aentity;
                if (!entity.func_174813_aQ().func_72326_a(aabb) || entity == entityIn) continue;
                if (filter == null || filter.apply((Object)entity)) {
                    listToFill.add(entity);
                }
                if ((aentity = entity.func_70021_al()) == null) continue;
                for (Entity entity1 : aentity) {
                    if (entity1 == entityIn || !entity1.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.apply((Object)entity1)) continue;
                    listToFill.add(entity1);
                }
            }
        }
    }
}

